# -*- coding: utf-8 -*-
"""
Created on Fri Jun 30 14:17:44 2017

@author: Joeri de Bruijckere
"""

# Provide ADwin functions and error routines
from ADwin import ADwin, ADwinError
import matplotlib.pyplot as plt
import time, numpy

DEVICENUMBER = 2
RAISE_EXCEPTIONS = 1
PROCESSORTYPE = '9' # '9' for T9, '10' for T10, '11' for T11
PROCESS = 'calibration.t91' # T9

max_V = 2
diff=1e-3
gain=4

min_digit = round(32768 - max_V*0.1*32768)
max_digit = round(32768 + max_V*0.1*32768)
sleep_time = 50 # sleep in between changing voltage and reading current (units of100ns)
resistance = 1e3 #sample resistance ohms
filename_save = 'cali_22Apr_gain4_1m_1KOhm_5us.txt'

try:
    # Generate an instance of the ADwin class, raise exceptions
    adw = ADwin(DEVICENUMBER, RAISE_EXCEPTIONS)
    print('Instance of ADwin class created...')
    
    # boot ADwin-system, load process and start it
    print('Booting ADwin system...')
    adw.Boot(adw.ADwindir + 'adwin'+PROCESSORTYPE+'.btl')
    print('ADwin system booted...')
    print('Loading process...')
    adw.Load_Process(PROCESS)
    print('Process loaded...')
    print('Loading process variables...')
    adw.Set_Par(1, min_digit)
    adw.Set_Par(2, max_digit)
    adw.Set_Par(3, sleep_time)
    print('Starting process...')
    adw.Start_Process(1)
    print('Process started...')
    time.sleep(65536*sleep_time*1e-7+1) 
    
    print('Process finished...')

    curr_dig = adw.GetData_Long(1, 0, 65536)
    v_dig = [x-32768 for x in range(65536)]

    plt.figure(figsize=(10,8))
    plt.plot(v_dig, curr_dig, '.', ms=0.7)
    plt.ylabel('Measured voltage (Adwin units)')
    plt.xlabel('Applied voltage (Adwin units)')
    
    file_data = (numpy.array(curr_dig)-32768)/3276.8/gain*diff
    file_data = file_data.T
    numpy.savetxt(filename_save,file_data)
    
except ADwinError as e:
    print('***', e) # error handling